<?php
/*
	DevSaver Web Framework
	Copyright (c) 2002-2018 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com
*/

if (!defined("STPBase")) {
	die("This file can't be accessed directly!");
}


$file = "
<IfModule mod_php4.c>
  php_flag engine Off
</IfModule>
<IfModule mod_php5.c>
  php_flag engine Off
</IfModule>
<IfModule mod_php6.c>
  php_flag engine Off
</IfModule>
<IfModule mod_cgi.c>
  Options -ExecCGI
</IfModule>

<Files *.php>
    Order Deny,Allow
    Deny from all
</Files>

<Files *.token>
    Order Deny,Allow
    Deny from all
</Files>

RemoveHandler .cgi .pl .py .pyc .pyo .phtml .php .php3 .php4 .php5 .php6 .pcgi .pcgi3 .pcgi4 .pcgi5 .pchi6 .inc
RemoveType .cgi .pl .py .pyc .pyo .phtml .php .php3 .php4 .php5 .php6 .pcgi .pcgi3 .pcgi4 .pcgi5 .pchi6 .inc
SetHandler None
#SetHandler default-handler
#ForceType text/plain";


SaveFileContents("../upload/.htaccess" , $file);

$output[] = "Generating /upload/.htaccess";


$file2 = '<?xml version="1.0" encoding="UTF-8"?>
<configuration>
  <system.webServer>
    <handlers accessPolicy="Read"/>
  </system.webServer>
</configuration>';

SaveFileContents("../upload/web.config" , $file);


$output[] = "Generating /upload/web.config";


?>